program CopyFile;

{$APPTYPE CONSOLE}

uses
  System,
  SysUtils,
  AnsiTo866 in 'AnsiTo866.pas';

// ----------------------------------------------------------------------------
//  . EInOutError
procedure ShowErrorCode(RqErrorCode : integer);
begin
    case RqErrorCode of
    2  : WriteLn('File not found');
    3  : WriteLn('Path not found');
    5  : WriteLn('I/O Error');
   13  : WriteLn('Access denied');
   32  : WriteLn('Sharing violation');
   100 : WriteLn('End of File');
   101 : WriteLn('Disk Full');
   102 : WriteLn('File variable not assigned');
   103 : WriteLn('File not open');
   104 : WriteLn('File not open for input');
   105 : WriteLn('File not open for output');
   106 : WriteLn('Error in formatted input');
   107 : WriteLn('File already open');
   else WriteLn('Unknown file I/O error');
   end;
end;

// ----------------------------------------------------------------------------
//   
function  TestFileExists (RqMsg : boolean; RqFileName : string) : boolean;
var Ok : boolean;
begin
  Ok := false;                       //  
  try
     Ok := FileExists(RqFileName);
     if not Ok
     then begin
         if RqMsg then WriteLn (#09 + 'MSG: File not found: ', RqFileName);
     end;
  except
     //      
     WriteLn (#09 + 'TRY-FILEEXIST: ERROR: Access denied : ', RqFileName);
  end;
  Result := Ok;                      //  
end;

// ----------------------------------------------------------------------------
//   
function OpenSourceFile (var RqF : file; RqFileName : string) : boolean;
var ErrorCode : integer;
begin
  Result := False;                  //  
  //      
  WriteLn('Source file  name  : ', RqFileName);

  try
    Assign(RqF, RqFileName);        //      
                                    //  
    {$I-}
    Reset(RqF, 1);                  // Open -   
                                    //   
    {$I+}
    ErrorCode := IOResult();        //     I/O
    if ErrorCode = 0                //     Open
    then begin
       Result := True;              //  
       WriteLn ('file size in bytes : ' + IntToStr(FileSize(RqF)))
    end
    else begin
       //      I/O
       WriteLn    (#09 + 'IORESULT: Source file I/O access error');
       WriteLnRus (#09 + SysErrorMessage(ErrorCode));
    end;
  except
      //      
      WriteLn (#09 + 'TRY-OPEN: ERROR: Access denied : ',RqFileName);
  end;
end;

// ----------------------------------------------------------------------------
//     
function PrepareTargetBackupFile (var RqF : file; RqFileName : string) : boolean;
var BackupFileName : string;
begin
  Result := False;                  //  
  BackupFileName := RqFileName + '.old';
  if TestFileExists (False, RqFileName)
  then begin
    try
       //  tatget-backup  ,    
       if TestFileExists (False, BackupFileName)
       then  DeleteFile (BackupFileName);
       Assign(RqF, RqFileName);     //      
                                    // ,   
       Rename(RqF, BackupFileName); //  
       Result := True;              //  
    except
      //      
      WriteLn (#09 + 'TRY-BACKUP: ERROR: Access denied : ', BackupFileName);
    end;
  end
  else Result := True;              //  
end;

// ----------------------------------------------------------------------------
//   
function OpenTargetFile (var RqF : file; RqFileName : string) : boolean;
var ErrorCode : integer;
begin
  Result := False;                 //  
  //      
  WriteLn('Target file  name  : ', RqFileName);

  if PrepareTargetBackupFile (RqF, RqFileName)
  then begin
    //    tatget-backup ,
    //    .
    try
      Assign(RqF, RqFileName);     //      
                                   //  
      {$I-}
      Rewrite(RqF, 1);             // Open -   
                                   //   
      {$I+}
      ErrorCode := IOResult();
      if ErrorCode = 0             //     Open
      then Result := True          //  
      else begin
        //      I/O
        WriteLn    (#09 + 'IORESULT: Target file I/O access denied');
        WriteLnRus (#09 + SysErrorMessage(ErrorCode));
      end;
    except
      //      
      WriteLn (#09 + 'TRY-OPEN: ERROR: Access denied : ',RqFileName);
    end;
  end;
end;

// ----------------------------------------------------------------------------
//       
procedure RunCopyFile   (RqFileNameSource,  RqFileNameTarget : string);
var FromF, ToF          : file;                      // File handlers
    NumRead, NumWritten : Integer;                   // Read / Write counter
    Buf                 : array[1..2048] of Char;    // Read / Write bufer
begin
   if TestFileExists(True, RqFileNameSource)
   then begin
      //  -  
      if OpenSourceFile(FromF, RqFileNameSource)
      then begin
         //  -  
         if OpenTargetFile (ToF, RqFileNameTarget)
         then begin
            //     
            //      
            repeat
               BlockRead (FromF, Buf, SizeOf(Buf), NumRead);
               BlockWrite(ToF,   Buf, NumRead,     NumWritten);
               // (NumRead = 0) -     
               // (NumWritten <> NumRead) -  
            until (NumRead = 0) or (NumWritten <> NumRead);
            if (NumWritten <> NumRead)
            then begin
               WriteLn (#09 + 'IO-ERROR: Target file record I/O error');
            end
            else begin
               //     
               WriteLn('Copying ', FileSize(ToF), ' bytes...');
            end;
            Close(ToF);   //   -  / Close target file
         end;
         Close(FromF);    //   -  / Close source file
      end;
   end;
end;

BEGIN
 WriteLn('================================================ ');
 WriteLn('            COPY FILE UTILITY ');
 WriteLn('------------------------------------------------ ');
 if ParamCount > 1
 then begin
   RunCopyFile   (ParamStr(1),  ParamStr(2));
 end
 else begin
    WriteLn(' USE format: ');
    WriteLn(' CopyFile.exe SourceFileName TargetFileName');
 end;

 WriteLn('================================================ ');
 Write  ('Press Enter key to continue ... ');
 ReadLn;
END.
